@extends('website.template')

@section('content')
  <!-- Page Title -->
        <div class="page-title-area">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="title-item">
                            <h2>الاتصال بنا</h2>
                            <ul>
                                <li>
                                    <a href="/">الرئيسية</a>
                                </li>
                                <li>
                                    <span>/</span>
                                </li>
                                <li>
                                    الاتصال بنا
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Title -->
        <!-- Contact -->
        <section class="contact-area pt-100 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="contact-item contact-left">
                            <h3>الاتصال بنا</h3>
                            <p>يمكنك التواصل معنا في مصنع الحمراء للبلاستيك بواسطة البيانات التالية </p>
                            <ul>
                                <li style="line-height: 33px;">
                                    <i class='bx bx-location-plus'></i>
المملكة العربية السعودية <br>
المدينة المنورة - المدينة الصناعية الجديدة <br>
ص.ب 40019 - الرمز البريدي: 42524                                </li>
                                <li>
                                    <i class='bx bx-mail-send'></i>
                                    <a href="mailto:info@hamrapl.com">
                                        info@hamrapl.com
                                    </a>
                                </li>
                                <li>
                                    <i class='bx bx-phone-call'></i>
                                    <a href="tel: +966555083469" style="direction: ltr;">
+966 55 508 3469
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact-item contact-right">
                            <h3>تواصل معنا</h3>


                   @if(session()->has('message'))

                    <div style="color: green; font-weight: bolder; font-size: 18px; text-align: center;">
   
                         {{ session()->get('message') }}

                    </div>
                    <p>&nbsp;</p>

                   @endif
                   
                            <form action="/contact" method="post" id="contactForm">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-4 col-lg-4">
                                        <div class="form-group">
                                            <input type="text" name="fullname" id="name" class="form-control" required data-error="الرجاء ادخال الاسم" placeholder="الاسم">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
        
                                    <div class="col-sm-4 col-lg-4">
                                        <div class="form-group">
                                            <input type="email" name="email" id="email" class="form-control" required data-error="الرجاء ادخال الايميل" placeholder="البريد الالكتروني">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>

                                    <div class="col-sm-4 col-lg-4">
                                        <div class="form-group">
                                            <input type="text" name="phone" id="phone_number" required data-error="الرجاء ادخال رقم الهاتف" class="form-control" placeholder="رقم الهاتف">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
            
        
                                    <div class="col-md-12 col-lg-12">
                                        <div class="form-group">
                                            <textarea name="details" class="form-control" id="message" cols="30" rows="8" required data-error="الرجاء كتابة رسالتك" placeholder="الرسالة"></textarea>
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
        
                                    <div class="col-md-12 col-lg-12">

                                        <input type="submit" name="submit" value="ارسال الرسالة" class="contact-btn btn">
                                        
                                        <div id="msgSubmit" class="h3 text-center hidden"></div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Contact -->


        <!-- Map -->
        <div class="map-area">
            <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3728196.189276877!2d40.5594564!3d24.1430784!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x15bdc4ce3b9934b9%3A0xdd75df06b8910637!2z2YXYtdmG2Lkg2KfZhNit2YXYsdin2KEg2YTZhNio2YTYp9iz2KrZitmD!5e0!3m2!1sar!2s!4v1598180921627!5m2!1sar!2s" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe>

          
        </div>
        <!-- End Map -->

@endsection
